package pl.model.validation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import pl.model.Employee;
import pl.model.EmployeeTypeEL;

public class EmployeeValidatorImpl implements
    ConstraintValidator<EmployeeValidator, Employee> {

  @Override
  public void initialize( EmployeeValidator arg0) {
  }

  @Override
  public boolean isValid( Employee employee, ConstraintValidatorContext context) {
    if ( employee.getType() == EmployeeTypeEL.MANAGER) {
      if ( employee.getDepartment() == null
          || employee.getDepartment().length() < 1) {
        return false;
      } else {
        return true;
      }

    }
    return true;
  }
}
