package pl.model.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

@Target( ElementType.TYPE)
@Retention( RetentionPolicy.RUNTIME)
@Constraint( validatedBy=EmployeeValidatorImpl.class)
public @interface EmployeeValidator {
  String message() default "Employee data is invalid!";

  Class<?>[] groups() default {};

  Class<? extends Payload>[] payload() default {};
}