package pl.model.converter;

import java.util.Set;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

import pl.model.Book;

@FacesConverter( value="pl.model.converter.BookListConverter")
public class BookListConverter implements Converter {
  @Override
  public Object getAsObject( FacesContext context, UIComponent component,
      String value) {
    return null;
  }

  @SuppressWarnings( "unchecked")
  @Override
  public String getAsString( FacesContext context, UIComponent component,
      Object value) {
    String result = "";
    int i = 0, n = 0;
    if ( value == null) {
      return null;
    } else if ( value instanceof Set<?>) {
      n = ((Set<Book>) value).size();
      for ( Book b : (Set<Book>) value) {
        result += b.getTitle();
        if ( i < n - 1) {
          result += "<br />";
        }
        i++;
      }
      return result;
    }
    return null;
  }
}