package pl.model.converter;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.persistence.EntityManager;

import pl.ctrl.BookController;
import pl.model.Book;

@FacesConverter( value="pl.model.converter.BookConverter")
public class BookConverter implements Converter {
  @Override
  public Object getAsObject( FacesContext context, UIComponent component,
      String value) {
    BookController ac = FacesContext
        .getCurrentInstance()
        .getApplication()
        .evaluateExpressionGet( context, "#{bookCtrl}",
            BookController.class);
    EntityManager em = ac.getEntityManager();
    if ( value == null) {
      return null;
    }
    return em.find( Book.class, value);
  }

  @Override
  public String getAsString( FacesContext context, UIComponent component,
      Object value) {
    if ( value == null) {
      return null;
    } else if ( value instanceof Book) {
      return ((Book) value).getIsbn();
    }
    return null;
  }
}