package pl.ctrl;

import java.util.HashSet;

import javax.annotation.Resource;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

import pl.model.Author;
import pl.model.Book;
import pl.model.Publisher;

@SessionScoped @ManagedBean( name="appCtrl")
public class AppController {
  @PersistenceContext( unitName="BidirAssocApp")
  private EntityManager em;
  @Resource private UserTransaction ut;

  /**
   * Clear/delete all entries from the database
   * 
   * @return a string representing the view name to display after finishing the
   *         execution of this method.
   * 
   * @throws NotSupportedException
   * @throws SystemException
   * @throws IllegalStateException
   * @throws SecurityException
   * @throws HeuristicMixedException
   * @throws HeuristicRollbackException
   * @throws RollbackException
   */
  public String clearData() {
    try {
      Book.clearData( em, ut);
      Publisher.clearData( em, ut);
      Author.clearData( em, ut);
    } catch ( Exception e) {
      e.printStackTrace();
    }
    return "index";
  }

  /**
   * Create test data (rows) in the database
   * 
   * @return a string representing the view name to display after finishing the
   *         execution of this method.
   * 
   * @throws NotSupportedException
   * @throws SystemException
   * @throws IllegalStateException
   * @throws SecurityException
   * @throws HeuristicMixedException
   * @throws HeuristicRollbackException
   * @throws RollbackException
   */
  public String createTestData() {
    try {
      this.clearData();
      final Publisher p1, p2;
      final Author a1, a2, a3;
      final Book b1, b2, b3;
      // clear existing publishers, so no primary key duplicate conflicts appear
      Publisher.clearData( em, ut);
      ut.begin();
      p1 = new Publisher( "Bantam Books", "New York, USA",
          new HashSet<Book>());
      em.persist( p1);
      p2 = new Publisher( "Basic Books", "New York, USA", new HashSet<Book>());
      em.persist( p2);
      a1 = new Author( 1, "Daniel Dennett", new HashSet<Book>());
      em.persist( a1);
      a2 = new Author( 2, "Douglas Hofstadter", new HashSet<Book>());
      em.persist( a2);
      a3 = new Author( 3, "Immanuel Kant", null);
      em.persist( a3);
      b1 = new Book( "006251587X", "Weaving the Web", 2000, p1,
          new HashSet<Author>());
      b1.addAuthor( a1);
      b1.addAuthor( a2);
      em.persist( b1);
      b2 = new Book( "0465026567", "Gdel, Escher, Bach", 1999, p2,
          new HashSet<Author>());
      b2.addAuthor( a2);
      em.persist( b2);
      b3 = new Book( "0465030793", "I Am A Strange Loop", 2008, null,
          new HashSet<Author>());
      b3.addAuthor( a3);
      em.persist( b3);
      // update publisher's published books
      p1.addPublishedBook( b1);
      p2.addPublishedBook( b2);
      // update author's authored books
      a1.addAuthoredBook( b1);
      a2.addAuthoredBook( b1);
      a2.addAuthoredBook( b2);
      a3.addAuthoredBook( b3);
      ut.commit();
    } catch ( Exception e) {
      e.printStackTrace();
    }
    return "index";
  }
}