package pl.model.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

@Target( { ElementType.FIELD, ElementType.METHOD })
@Retention( RetentionPolicy.RUNTIME)
@Constraint( validatedBy=UpToNextYearImpl.class)
public @interface UpToNextYear {
  String message() default "The year must be between 1459 and next year!";

  Class<?>[] groups() default {};

  Class<? extends Payload>[] payload() default {};
}