package pl.model;

/**
 * Enumeration of available languages and their corresponding labels.
 *
 */
public enum LanguageEL {
  EN( "English"),
  DE( "German"), 
  FR( "French"), 
  ES( "Spanish");

  // associated label for an enumeration literal
  private final String label;

  /**
   * Constructor
   */
  private LanguageEL( String label) {
    this.label = label;
  }

  public String getLabel() {
    return this.label;
  }
}