#include <KMPDinoWiFiESP.h>
#include <KMPCommon.h>
#include <ESP8266WebServer.h>

const char WIFI_PSK[] = "1a2b3c4d";
const char SSID[] = "Charlie's Home";
const uint8_t PORT = 80;
ESP8266WebServer webServer(PORT);

void setup(void) {
  // initialize the PRODINo board
  KMPDinoWiFiESP.init();
  // setup the WiFi module as AccesPoint (AP Mode).
  WiFi.mode(WIFI_AP);
  // set the SSID and Password for the AP
  WiFi.softAP(SSID, WIFI_PSK);
  // set the HTTP route for the relay control
  webServer.on("/relay", handleRelayRoute);
  // start the web server
  webServer.begin();
}

void loop(void) {
  webServer.handleClient();
}

void handleRelayRoute() {
   int8_t relayId = -1;
   bool relayState = 0;
  // incomming POST request (two expected params: relayId and relayState).
  if (webServer.method() == HTTP_POST && webServer.args() == 2) {
    for (uint8_t i = 0; i < webServer.args(); i++) {
      if (webServer.argName(i) == "relayId") {
        relayId = CharToInt(webServer.arg(i)[0]);
      } else if (webServer.argName(i) == "relayState") {
        relayState = CharToInt(webServer.arg(i)[0]);
      }
    }
    KMPDinoWiFiESP.SetRelayState(relayId, relayState);
    webServer.send(200, TEXT_HTML, "OK");
  } else {
    webServer.send(400, TEXT_HTML, "Bad request");
  }  
}
